<?php
/* --------------------------------------------------------------
   DeleteParcelServicesAction.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\ParcelService\Actions;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceService;
use Gambio\Admin\ParcelService\Model\ParcelServiceId;
use Gambio\Admin\ParcelService\Model\ParcelServiceIds;
use Slim\Http\Response;
use Slim\Http\ServerRequest as Request;

/**
 * Class DeleteParcelServicesAction
 *
 * @package Gambio\Api\ParcelService\Actions
 */
class DeleteParcelServicesAction
{
    /**
     * @var ParcelServiceService
     */
    private $service;
    
    
    /**
     * DeleteParcelServicesAction constructor.
     *
     * @param ParcelServiceService $service
     */
    public function __construct(ParcelServiceService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @param Request  $request
     * @param Response $response
     * @param array    $args
     *
     * @return Response
     */
    public function __invoke(Request $request, Response $response, array $args): Response
    {
        $ids = [];
        if ($request->getAttribute('ids') !== null) {
            foreach (explode(',', $request->getAttribute('ids')) as $id) {
                $ids[] = ParcelServiceId::create((int)$id);
            }
        }
        
        $this->service->deleteParcelServices(ParcelServiceIds::create(...$ids));
        
        return $response->withStatus(204);
    }
}